/* ///////////////////////////////////////////////////////////////////////// */
/*  This is part of the source of the OMAP 5912 heterogeneous dual-core      */
/*  MPEG-4 SP video decoder published in ACM Transactions on Embedded        */
/*  Computing Systems, Vol. X, Issue Y.                                      */
/* ------------------------------------------------------------------------- */
/*  The source code is released under GPL license.                           */
/*                                                                           */
/*  Copyright, 2011                                                          */
/*  Multimedia Embedded Systems Labs                                         */
/*  Dept. of Computer Science                                                */
/*  National Chiao Tung University                                           */
/*  Hsinchu, Taiwan.                                                         */
/* ///////////////////////////////////////////////////////////////////////// */

#ifndef _MEM_TRANSFER_H
#define _MEM_TRANSFER_H

void    transfer_8to16copy(int16 * const dst, const uint8 * const src,
                           xint stride);
void    transfer_16to8copy(uint16 * const dst, const int16 * const src,
                           xint stride);
void    transfer_8to16sub(int16 * const dct, uint8 * const cur,
                          const uint8 * ref, xint stride);
void    transfer_16to8add(uint16 * const dst, const int16 * const src,
                          xint stride);
void    transfer8x8_copy(uint16 * const dst, const uint16 * const src,
                         xint stride);
#endif /* _MEM_TRANSFER_H_ */
